import { BigNumber } from '@ethersproject/bignumber';
import { ChainId, Currency } from '@uniswap/sdk-core';
import { V3Route, V4Route } from '../../router';
export declare const COST_PER_UNINIT_TICK: BigNumber;
export declare const BASE_SWAP_COST: (id: ChainId) => BigNumber;
export declare const COST_PER_INIT_TICK: (id: ChainId) => BigNumber;
export declare const COST_PER_HOP: (id: ChainId) => BigNumber;
export declare const SINGLE_HOP_OVERHEAD: (_id: ChainId) => BigNumber;
export declare const TOKEN_OVERHEAD: (id: ChainId, route: V3Route | V4Route) => BigNumber;
export declare const NATIVE_WRAP_OVERHEAD: (id: ChainId) => BigNumber;
export declare const NATIVE_UNWRAP_OVERHEAD: (id: ChainId) => BigNumber;
export declare const NATIVE_OVERHEAD: (chainId: ChainId, amount: Currency, quote: Currency) => BigNumber;
